<?php

include 'header.php'; 
// Fetch all lessons
$lessons = [];
$result = $conn->query("SELECT * FROM lessons ORDER BY `order` ASC");
if ($result) {
    $lessons = $result->fetch_all(MYSQLI_ASSOC);
}
?>


    <!-- Custom CSS -->
    <style>
        .lesson-card {
            transition: all 0.3s ease;
            border-radius: 12px;
            overflow: hidden;
            height: 100%;
        }
        .lesson-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .lesson-img {
            height: 180px;
            object-fit: cover;
            width: 100%;
        }
        .progress-sm {
            height: 5px;
        }
        .badge-video {
            background-color: #0ab39c;
        }
        .badge-youtube {
            background-color: #299cdb;
        }
        .search-box {
            max-width: 400px;
        }
        .category-filter {
            min-width: 200px;
        }
    </style>

            <div class="page-content">
                <div class="container-fluid">
                    <!-- Start Content -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">All Lessons</h4>
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                                        <li class="breadcrumb-item active">Lessons</li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter and Search -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-search-line"></i></span>
                                <input type="text" class="form-control search-box" placeholder="Search lessons...">
                                <button class="btn btn-primary" type="button">Search</button>
                            </div>
                        </div>
                       
                    </div>

                    <!-- Lessons Grid -->
                    <div class="row">
                        <?php foreach ($lessons as $lesson): ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="card lesson-card">
                                <img src="https://admin.autobpo.ai/<?php echo $lesson['image'] ? $lesson['image'] : 'assets/images/default-lesson.jpg'; ?>" class="card-img-top lesson-img" alt="Lesson Image">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-2">
                                        <span class="badge <?php echo $lesson['type'] == 'video' ? 'badge-video' : 'badge-youtube'; ?> me-2">
                                            <?php echo ucfirst($lesson['type']); ?>
                                        </span>
                                        <!--<span class="text-muted small"><i class="ri-time-line me-1"></i> 25 min</span>-->
                                    </div>
                                    <h5 class="card-title mb-3"><?php echo htmlspecialchars($lesson['name']); ?></h5>
                                    <p class="card-text text-muted"><?php echo substr(htmlspecialchars($lesson['description']), 0, 100); ?>...</p>
                                    
                                    <div class="d-flex align-items-center justify-content-between mt-3">
                                       
                                        <a href="lesson.php?id=<?php echo $lesson['id']; ?>" class="w-100 btn btn-sm btn-primary">
                                            <i class="ri-play-circle-line me-1"></i> View
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        
                        <?php if (empty($lessons)): ?>
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body text-center py-5">
                                    <img src="assets/images/no-data.svg" alt="No lessons" height="150" class="mb-4">
                                    <h4>No Lessons Available</h4>
                                    <p class="text-muted">Check back later or contact your instructor</p>
                                    <a href="#" class="btn btn-primary">Explore Other Courses</a>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                   

    
    <!-- Custom JS -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Filter lessons
            const searchInput = document.querySelector('.search-box');
            searchInput.addEventListener('input', function() {
                const searchTerm = this.value.toLowerCase();
                const lessonCards = document.querySelectorAll('.lesson-card');
                
                lessonCards.forEach(card => {
                    const title = card.querySelector('.card-title').textContent.toLowerCase();
                    const description = card.querySelector('.card-text').textContent.toLowerCase();
                    
                    if (title.includes(searchTerm) || description.includes(searchTerm)) {
                        card.closest('.col-xl-3').style.display = 'block';
                    } else {
                        card.closest('.col-xl-3').style.display = 'none';
                    }
                });
            });
            
            // Add click animation to cards
            const cards = document.querySelectorAll('.lesson-card');
            cards.forEach(card => {
                card.addEventListener('click', function() {
                    this.style.transform = 'scale(0.98)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 200);
                });
            });
        });
    </script>

<?php include "footer.php"; ?>
