<?php include 'header.php'; ?>

<?php
// Load Upwork settings
$settings = null;
$stmt = $conn->prepare("SELECT * FROM upwork_settings WHERE user_id = ? LIMIT 1");
$stmt->bind_param("s", $userId);
if ($stmt->execute()) {
    $res = $stmt->get_result();
    if ($res && $res->num_rows === 1) {
        $settings = $res->fetch_assoc();
    }
}
$stmt->close();

// Load Upwork credentials
$upworkCreds = null;
$stmt = $conn->prepare("SELECT * FROM upwork WHERE user_id = ? LIMIT 1");
$stmt->bind_param("s", $userId);
if ($stmt->execute()) {
    $res = $stmt->get_result();
    if ($res && $res->num_rows === 1) {
        $upworkCreds = $res->fetch_assoc();
    }
}
$stmt->close();
?>


<div class="page-content">
    <div class="container-fluid">

          <!-- start page title -->
          <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                    <h4 class="mb-sm-0">Search</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Upwork</a></li>
                            <li class="breadcrumb-item active">Search</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-12">
                <!-- Search Interface -->
                <div class="mb-3">
                            <div class="d-flex">
                                <input
                                    type="text"
                                    id="searchInput"
                                    class="form-control"
                                    placeholder="Enter search keyword..."
                                />
                                <button
                                    id="searchBtn"
                                    class="btn btn-primary btn-sm ms-2"
                                    type="button"
                                >
                                    <i class="ri-search-line me-1"></i>
                                    Search
                                </button>
                            </div>
                        </div>


                        <!-- Loading State -->
                        <div id="loadingState" class="text-center py-4" style="display: none; min-height: 400px;">
                            <div class="spinner-border text-primary mt-12" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <p class="mt-2">⏳ Fetching jobs...</p>
                        </div>

                        <!-- Results Container -->
                        <div id="resultsContainer"></div>
                                                <!-- Pagination Controls -->
                                                <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center gap-3">
                                <label for="jobs-per-page" class="form-label mb-0">Jobs Per Page:</label>
                                <select id="jobs-per-page" class="form-select" style="width: auto;">
                                    <option value="5">5</option>
                                    <option value="10" selected>10</option>
                                    <option value="20">20</option>
                                    <option value="30">30</option>
                                    <option value="50">50</option>
                                </select>
                            </div>

                            <div id="paginationControls" class="d-flex align-items-center gap-2" style="display: none !important;">
                                <button id="prevPageBtn" class="btn btn-outline-secondary btn-sm">
                                    <i class="ri-arrow-left-s-line"></i>
                                </button>
                                
                                <span id="pageInfo" class="mx-2"></span>
                                
                                <button id="nextPageBtn" class="btn btn-outline-secondary btn-sm">
                                    <i class="ri-arrow-right-s-line"></i>
                                </button>
                            </div>
                        </div>

            </div>
        </div>
    </div>
</div>

<!-- Bid Modal -->
<div class="modal fade" id="bidModal" tabindex="-1" aria-labelledby="bidModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="bidModalLabel">Review & Confirm Bid</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Generated Proposal:</label>
                    <textarea class="form-control" id="generatedMessage" rows="10" placeholder="Edit your proposal here..."></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Bid Amount ($):</label>
                    <input type="number" class="form-control" id="bidPrice" min="0" step="1">
                    <small class="text-muted" id="bidInfo"></small>
                </div>
                <div id="bidResponse" style="display: none;"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="submitBidBtn">
                    <span id="submitBidText">Submit Bid</span>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Pass data to JavaScript -->
<script>
const upworkSettings = <?php echo json_encode($settings); ?>;
const upworkCreds = <?php echo json_encode($upworkCreds); ?>;
</script>

<!-- Include search.js -->
<script src="searchjs.php"></script>

<?php include 'footer.php'; ?>