<?php
// updatetoken.php

header("Content-Type: application/json");

// 1. Get data from query string (?data=...)
$data = isset($_GET['data']) ? $_GET['data'] : null;

// 2. Filter cookies that contain 'oauth' in their value
$oauthCookies = [];
foreach ($_COOKIE as $key => $value) {
    if (strpos($value, 'oauth') !== false) {
        $oauthCookies[] = [$key => $value];
    }
}

// 3. Extract specific cookies
$console_user = isset($_COOKIE['console_user']) ? $_COOKIE['console_user'] : null;
$user_uid = isset($_COOKIE['user_uid']) ? $_COOKIE['user_uid'] : null;

// 4. Build response
$response = [
    "message" => "success",
    "receivedData" => $data,
    "oauthCookies" => $oauthCookies,
    "console_user" => $console_user,
    "user_uid" => $user_uid
];

// 5. Send JSON response
echo json_encode($response);
